<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'phone', 'email', 'password', 'blood_type_id', 'date_of_birth', 'last_donation_date', 'city_id', 'pin_code');

    public function BloodType()
    {
        return $this->belongsTo('App\Models\BloodType');
    }

    public function City()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function DonationRequests()
    {
        return $this->hasMany('App\Models\DonationRequest');
    }

}